{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 09.01.99 - 13:51:46 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMDIBCv, MMLevel, MMConect, MMHook, MMDesign, MMDSPObj,
  MMUtils, MMWavOut, MMAudio, MMSlider, ExtCtrls, MMWave, MMACMCvt,
  MMDSWOut;

type
  TForm1 = class(TForm)
    AudioFile: TMMAudioFile;
    WaveOut: TMMWaveOut;
    MMDesigner1: TMMDesigner;
    MMConnector1: TMMConnector;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    btnPlay: TButton;
    btnStop: TButton;
    btnFade: TButton;
    Slider: TMMSlider;
    Timer1: TTimer;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure btnFadeClick(Sender: TObject);
    procedure SliderTrack(Sender: TObject);
    procedure SliderTrackEnd(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    Seeking: Boolean;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
{$R AUDIO.RES}

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStart(Sender: TObject);
begin
   btnPlay.Enabled := False;
   btnStop.Enabled := True;
   btnFade.Enabled := True;
   Slider.Enabled  := True;
   Timer1.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   WaveOut.Close;
   btnPlay.Enabled := True;
   btnStop.Enabled := False;
   btnFade.Enabled := False;
   Slider.Enabled  := False;
   Timer1.Enabled := False;
   Slider.Position := 0;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
begin
   if (AudioFile.FileName = '') then
   begin
      AudioFile.FileName := 'RESOURCE://Track01';
      // here you can set also fade params
      //AudioFile.FadeInDuration := 2000;
      //AudioFile.FadeOutDuration:= 2000;
      //AudioFile.FadeOutPosition:= AudioFile.FileLength-AudioFile.FadeOutDuration;
      Slider.MaxValue := AudioFile.PlayLength;
      WaveOut.Start;
   end
   else if not AudioFile.Empty then WaveOut.Start;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   WaveOut.Stop;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnFadeClick(Sender: TObject);
begin
   AudioFile.FadeOut(5000);
end;

{------------------------------------------------------------------------------}
procedure TForm1.SliderTrack(Sender: TObject);
begin
   Seeking := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.SliderTrackEnd(Sender: TObject);
begin
   WaveOut.Pause;
   AudioFile.Position   := Slider.Position;
   WaveOut.Reset;
   WaveOut.Restart;
   Seeking := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Timer1Timer(Sender: TObject);
begin
   if not Seeking then Slider.Position := AudioFile.Position;
end;

end.


